% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/high_level_UI.R
\name{H5Group_access}
\alias{H5Group_access}
\alias{[[.H5Group}
\alias{[[.H5File}
\alias{[[<-.H5Group}
\alias{[[<-.H5File}
\title{Retrieve object from a group of file}
\usage{
\method{[[}{H5Group}(x, name, ..., link_access_pl = h5const$H5P_DEFAULT,
  dataset_access_pl = h5const$H5P_DEFAULT,
  type_access_pl = h5const$H5P_DEFAULT)

\method{[[}{H5File}(x, name, ..., link_access_pl = h5const$H5P_DEFAULT,
  dataset_access_pl = h5const$H5P_DEFAULT,
  type_access_pl = h5const$H5P_DEFAULT)

\method{[[}{H5Group}(x, name, ...) <- value

\method{[[}{H5File}(x, name, ...) <- value
}
\arguments{
\item{x}{An object of class \code{\link{H5File}} or \code{\link{H5Group}}}

\item{name}{Name of the object to retrieve. Has to be a character vector of length one. No integer values allowed.}

\item{...}{Currently ignored}

\item{link_access_pl}{An object of class \code{\link{H5P_LINK_ACCESS}}.}

\item{dataset_access_pl}{An object of class \code{\link{H5P_DATASET_ACCESS}}.}

\item{type_access_pl}{Currently always \code{h5const$H5P_DEFAULT}}

\item{value}{What to assign. Has to be one of \code{\link{H5Group}},  \code{\link{H5D}} or  \code{\link{H5T}}}
}
\value{
A \code{\link{H5Group}},  \code{\link{H5D}} or  \code{\link{H5T}}, depending on the object saved in the group under
the requested name.
}
\description{
Retrieve object from a group of file
}
\details{
Works similar to retrieving objects in a list. \code{x[["my_name"]]} retrieves object \code{my_name} from the
HDF5-File or HDF5-Group \code{x}.

One can also assign objects under a not yet existing name. For either a  \code{\link{H5Group}} or \code{\link{H5D}},
a hard link is created. If it is a datatype, \code{\link{H5T}}, this is committed under the chosen name \code{name}.
}
\author{
Holger Hoefling
}
