% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_summaries.R
\name{plot_tau}
\alias{plot_tau}
\title{Plot tau}
\usage{
plot_tau(
  samples,
  X = NULL,
  W = NULL,
  title = NULL,
  true.tau = NULL,
  show.all.taus = FALSE,
  show.all.betas = FALSE,
  ncol = NULL,
  legend.position = "top",
  x.axis.size = 1.1,
  y.axis.size = 1.1,
  title.size = 1.2,
  panel.title.size = 1.4,
  legend.size = 1,
  xlab = NULL
)
}
\arguments{
\item{samples}{an output of the function \code{\link{hdpGLM}}}

\item{X}{a string vector with the name of the first-level covariates whose associated tau should be displayed}

\item{W}{a string vector with the name of the context-level covariate(s) whose linear effect will be displayed. If \code{NULL}, the linear effect tau of all context-level covariates are displayed. Note: the context-level covariate must have been included in the estimation of the model.}

\item{title}{string, title of the plot}

\item{true.tau}{a \code{data.frame} with four columns. The first must be named \code{w} and it indicates the index of each context-level covariate, starting with 0 for the intercept term. The second column named \code{beta} must contain the indexes of the betas of individual-level covariates, starting with 0 for the intercept term. The third column named \code{Parameter} must be named \code{tau<w><beta>}, where \code{w} and \code{beta} must be the actual values displayed in the columns \code{w} and \code{beta}. Finally, it must have a column named \code{True} with the true value of the parameter.}

\item{show.all.taus}{boolean, if \code{FALSE} (default) the posterior distribution of taus representing the intercept of the expectation of beta are omitted}

\item{show.all.betas}{boolean, if \code{FALSE} (default) the taus affecting only the intercept terms of the outcome variable are omitted}

\item{ncol}{number of columns of the grid. If \code{NULL}, one column is used}

\item{legend.position}{one of four options: "bottom" (default), "top", "left", or "right". It indicates the position of the legend}

\item{x.axis.size}{numeric, the relative size of the label in the x-axis}

\item{y.axis.size}{numeric, the relative size of the label in the y-axis}

\item{title.size}{numeric, the relative size of the title of the plot}

\item{panel.title.size}{numeric, the relative size of the titles in the panel of the plot}

\item{legend.size}{numeric, the relative size of the legend}

\item{xlab}{string, the label of the x-axis}
}
\description{
Function to plot posterior distribution of tau
}
\examples{

library(magrittr)
set.seed(66)

# Note: this example is just for illustration. MCMC iterations are very reduced
set.seed(10)
n = 20
data.context1 = tibble::tibble(x1 = rnorm(n, -3),
                                   x2 = rnorm(n,  3),
                                   z  = sample(1:3, n, replace=TRUE),
                                   y  =I(z==1) * (3 + 4*x1 - x2 + rnorm(n)) +
                                       I(z==2) * (3 + 2*x1 + x2 + rnorm(n)) +
                                       I(z==3) * (3 - 4*x1 - x2 + rnorm(n)) ,
                                   w = 20
                                   ) 
data.context2 = tibble::tibble(x1 = rnorm(n, -3),
                                   x2 = rnorm(n,  3),
                                   z  = sample(1:2, n, replace=TRUE),
                                   y  =I(z==1) * (1 + 3*x1 - 2*x2 + rnorm(n)) +
                                       I(z==2) * (1 - 2*x1 +   x2 + rnorm(n)),
                                   w = 10
                                   ) 
data = data.context1 \%>\%
    dplyr::bind_rows(data.context2)

## estimation
mcmc    = list(burn.in=1, n.iter=50)
samples = hdpGLM(y ~ x1 + x2, y ~ w, data=data, mcmc=mcmc, n.display=1)


plot_tau(samples)
plot_tau(samples, ncol=2)
plot_tau(samples, X='x1', W='w')
plot_tau(samples, show.all.taus=TRUE, show.all.betas=TRUE, ncol=2)

}
