% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdr.R
\name{hdr.boxplot}
\alias{hdr.boxplot}
\title{Highest Density Region Boxplots}
\usage{
hdr.boxplot(
  x,
  prob = c(99, 50),
  h = hdrbw(BoxCox(x, lambda), mean(prob)),
  lambda = 1,
  boxlabels = "",
  col = gray((9:1)/10),
  main = "",
  xlab = "",
  ylab = "",
  pch = 1,
  border = 1,
  outline = TRUE,
  space = 0.25,
  ...
)
}
\arguments{
\item{x}{Numeric vector containing data or a list containing several vectors.}

\item{prob}{Probability coverage required for HDRs
\code{\link[stats]{density}}.}

\item{h}{Optional bandwidth for calculation of density.}

\item{lambda}{Box-Cox transformation parameter where \code{0 <= lambda <=
1}.}

\item{boxlabels}{Label for each box plotted.}

\item{col}{Colours for regions of each box.}

\item{main}{Overall title for the plot.}

\item{xlab}{Label for x-axis.}

\item{ylab}{Label for y-axis.}

\item{pch}{Plotting character.}

\item{border}{Width of border of box.}

\item{outline}{If not <code>TRUE</code>, the outliers are not drawn.}

\item{space}{The space between each box, between 0 and 0.5.}

\item{\dots}{Other arguments passed to plot.}
}
\value{
nothing.
}
\description{
Calculates and plots a univariate highest density regions boxplot.
}
\details{
The density is estimated using kernel density estimation. A Box-Cox
transformation is used if \code{lambda!=1}, as described in Wand, Marron and
Ruppert (1991). This allows the density estimate to be non-zero only on the
positive real line. The default kernel bandwidth \code{h} is selected using
the algorithm of Samworth and Wand (2010).

Hyndman's (1996) density quantile algorithm is used for calculation.
}
\examples{
# Old faithful eruption duration times
hdr.boxplot(faithful$eruptions)

# Simple bimodal example
x <- c(rnorm(100,0,1), rnorm(100,5,1))
par(mfrow=c(1,2))
boxplot(x)
hdr.boxplot(x)

# Highly skewed example
x <- exp(rnorm(100,0,1))
par(mfrow=c(1,2))
boxplot(x)
hdr.boxplot(x,lambda=0)

}
\references{
Hyndman, R.J. (1996) Computing and graphing highest density
regions. \emph{American Statistician}, \bold{50}, 120-126.

Samworth, R.J. and Wand, M.P. (2010). Asymptotics and optimal bandwidth
selection for highest density region estimation.  \emph{The Annals of
Statistics}, \bold{38}, 1767-1792.

Wand, M.P., Marron, J S., Ruppert, D. (1991) Transformations in density
estimation. \emph{Journal of the American Statistical Association},
\bold{86}, 343-353.
}
\seealso{
\code{\link{hdr.boxplot.2d}}, \code{\link{hdr}}, \code{\link{hdr.den}}
}
\author{
Rob J Hyndman
}
\keyword{distribution}
\keyword{hplot}
\keyword{smooth}
