% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_calc.R
\name{div_calc}
\alias{div_calc}
\title{Diversion Ratio Calculator}
\usage{
div_calc(
  data,
  cell = "cell",
  hosp_id = "hosp_id",
  hospital = "hospital",
  sys_id = "sys_id",
  party_ind = "party_ind",
  count = "count",
  dropDegenerateCell = TRUE
)
}
\arguments{
\item{data}{Dataset of hospital discharges, with required variables:
\code{cell}, \code{hosp_id}, \code{hospital}, \code{sys_id},
\code{party_ind}, \code{count}. Use other function arguments to
indicate alternative variable names to the default names.}

\item{cell}{Name of variable specifying cell to which each observation
has been allocated. Default variable name is \code{cell}. Can be
created by \code{cell_defn} function.}

\item{hosp_id}{Name of variable specifying (numeric) hospital
identifier. Default variable name is \code{hosp_id}.}

\item{hospital}{Name of variable specifying (string) hospital name.
Default variable name is \code{hospital}.}

\item{sys_id}{Name of variable specifying (numeric) system identifier.
Default variable name is \code{sys_id}.}

\item{party_ind}{Name of indicator variable for whether hospital is a
merging party from which diversions should be calculated. Default
variable name is \code{party_ind}.}

\item{count}{Name of variable indicating the number of admissions
represented by the observation. Set = 1 for every row if each
observation represents one admission.}

\item{dropDegenerateCell}{logical; specifies how to treat cells with a
100 percent within-system share. If TRUE, observations in degenerate, 100
percent share cells will be ignored in the diversion ratio calculation.
If FALSE, any such individuals will be assigned to the outside option,
but still included in the denominator, so that the inside-option diversion
will total less than 100  percent.}
}
\value{
A list with two components. The first component, \code{hosp_level},
is a matrix giving hospital-level diversions from party hospitals to
all other hospitals. The second object, \code{sys_level}, is a matrix that
aggregates party hospitals to systems, thus giving diversions from party
systems to all other hospitals.
}
\description{
Calculates hospital-level diversion ratios, once cells have been
defined.
}
\details{
For system-to-system diversions, set \code{hosp_id} and
\code{hospital} equal to corresponding system-level identifiers.
Patients are not allowed to divert to within-system alternative
hospitals.

For more details see the example vignette by typing:
\code{vignette("semipar_example", package = "healthcare.antitrust")}
}
\examples{
data(discharge_data, package = "healthcare.antitrust")

list1 <- c("drg","age","zip5")
layers <- list(list1)
th <- 15
discharge_data$count <- 1

outList <- cell_defn(discharge_data,th,layers)
D0 <- outList$assigned

D0$party_ind <- 0
D0$party_ind[D0$hosp_id==1] <- 1
D0$party_ind[D0$hosp_id==2] <- 1
D0$party_ind[D0$hosp_id==5] <- 1

out <- div_calc(D0)

}
