% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_predictions.R
\name{plot.predicted_df}
\alias{plot.predicted_df}
\alias{plot_regression_predictions}
\alias{plot_classification_predictions}
\alias{plot_multiclass_predictions}
\title{Plot model predictions vs observed outcomes}
\usage{
\method{plot}{predicted_df}(x, caption = TRUE, title = NULL,
  font_size = 11, outcomes = NULL, fixed_aspect = attr(x,
  "model_info")$type == "Regression", print = TRUE, ...)

plot_regression_predictions(x, point_size = 1, point_alpha = 1, target)

plot_classification_predictions(x, fill_colors = c("firebrick", "steelblue"),
  fill_alpha = 0.7, curve_flex = 1, add_labels = TRUE, target)

plot_multiclass_predictions(x, conf_colors = c("black", "steelblue"),
  text_color = "yellow", diag_color = "red", target)
}
\arguments{
\item{x}{data frame as returned `predict.model_list`}

\item{caption}{Put model performance in plot caption? TRUE (default) prints
all available metrics, FALSE prints nothing. Can also provide metric name
(e.g. "RMSE"), in which case the caption will include only that metric.}

\item{title}{Character: Plot title, default NULL produces no title.}

\item{font_size}{Number: Relative size of all font in plot, default = 11}

\item{outcomes}{Vector of outcomes if not present in x}

\item{fixed_aspect}{Logical: If TRUE (default for regression only), units of
the x- and y-axis will have the same spacing.}

\item{print}{Logical, if TRUE (default) the plot is printed on the current
graphics device. The plot is always (silently) returned.}

\item{...}{Parameters specific to plot_regression_predictions or
plot_classification_predictions; listed below. These must be named.}

\item{point_size}{Number: Point size, relative to 1}

\item{point_alpha}{Number in [0, 1] giving point opacity}

\item{target}{Not meant to be set by user. outcome column name}

\item{fill_colors}{Length-2 character vector: colors to fill density curves.
Default is c("firebrick", "steelblue"). If named, names must match
\code{unique(x[[target]])}, in any order.}

\item{fill_alpha}{Number in [0, 1] giving opacity of fill colors.}

\item{curve_flex}{Numeric. Kernal adjustment for density curves. Default is
1. Less than 1 makes curves more flexible, analogous to smaller bins in a
histogram; greater than 1 makes curves more rigid.}

\item{add_labels}{If TRUE (default) and a predicted_group column was added to
predictions by specifying \code{risk_groups} or \code{outcome_groups} in
\code{link{predict.model_list}}, labels specifying groups are added to the
plot.}

\item{conf_colors}{Length-2 character vector: colors to fill density curves.
Default is c("black", "steelblue").}

\item{text_color}{Character: color to write percent correct.
Default is "yellow".}

\item{diag_color}{Character: color to highlight main diagonal. These are
correct predictions. Default is "red".}
}
\value{
A ggplot object
}
\description{
Plot model predictions vs observed outcomes
}
\details{
Note that a ggplot object is returned, so you can do additional
  customization of the plot. See the third example.
}
\examples{
# Some regression examples
models <- machine_learn(pima_diabetes[1:50, ], patient_id, outcome = plasma_glucose,
                        models = "rf", tune = FALSE)
predictions <- predict(models)
plot(predictions)
plot(predictions, caption = "Rsquared",
     title = "This model's predictions regress to the mean",
     point_size = 3, point_alpha = .7, font_size = 14)
p <- plot(predictions, print = FALSE)
p + theme_classic()

# A classification example with risk groups
class_models <- machine_learn(pima_diabetes, patient_id, outcome = diabetes,
                              models = "xgb", tune = FALSE)
predict(class_models,
        risk_groups = c("v low", "low", "medium", "high", "very high")) \%>\%
  plot()
}
