% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_load.R
\name{save_models}
\alias{save_models}
\alias{load_models}
\title{Save models to disk and load models from disk}
\usage{
save_models(x, filename = "models.RDS", sanitize_phi = TRUE)

load_models(filename)
}
\arguments{
\item{x}{model_list object}

\item{filename}{File path to save model to or read model from, e.g.
"models/my_models.RDS". Default for \code{save_models} is "models.RDS" in
the working directory (\code{getwd()}). Default for \code{load_models} is
to open a dialog box from which a file can be selected, in which case a
message will issued with code to load the same file without interactivity.}

\item{sanitize_phi}{Logical. If TRUE (default) training data is removed from
the model object before being saved. Removing training data is important
when sharing models that were trained with data that contain PHI. If
removed, \code{\link{explore}} will not have data to process.}
}
\value{
\code{load_models} returns the model_list which can be assigned to
  any variable name
}
\description{
Note that model objects contain training data, except columns
  ignored (patient_id in the example below). Therefore, if there is PHI in
  the training data, the saved model object must be treated as PHI.
  \code{save_models} issues a message saying as much.
}
\examples{
\donttest{
m <- machine_learn(pima_diabetes, patient_id, outcome = diabetes)
file <- paste0(tempdir(), "/diabetes_models.RDS")
save_models(m, file)
# Restart R, move RDS file to another computer, etc.
m2 <- load_models(file)
all.equal(m, m2)
}
}
