% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_def.R
\name{build_def}
\alias{build_def}
\title{Build case definition function calls}
\usage{
build_def(def_lab, src_labs, def_fn = define_case, fn_args)
}
\arguments{
\item{def_lab}{A single character label for the definition, e.g., some disease.}

\item{src_labs}{A character vector of place-holder names for the data sources that will be used to execute the definition.}

\item{def_fn}{A list of functions (default: \code{\link[=define_case]{define_case()}}) that will filter the source data sets and keep clients met the case definition. The length of the list should be either 1 or equal to the length of \code{src_labs}. If length = 1, the same function will be applied to all sources; otherwise, \code{def_fn} should match \code{src_lab} by position. User can supply custom functions but must put input data as the first argument and name it \code{data}.}

\item{fn_args}{A named list of arguments passing to the \code{def_fn}. Each element in the list should have the same name as an argument in the source-specific \code{def_fn}, and the element length should also be either 1 or equal to the number of sources. If you have \code{def_fn} functions taking different sets of arguments, include the union in one list.}
}
\value{
A tibble with a number of rows equal to the length of \code{src_labs}, containing the input arguments and the synthetic function call in the \code{fn_call} column.
}
\description{
This function assembles function calls from the supplied functions and their required arguments, leaving the data argument empty for easy re-use of the definition calls with different data and batch execution (see \code{\link[=execute_def]{execute_def()}} for detail). It is useful for defining multiple diseases/events across multiple sources.
}
\examples{
build_def("SUD", # usually a disease name
  src_lab = c("src1", "src2"), # identify from multiple sources, e.g., hospitalization, ED visits.
  # functions that filter the data with some criteria,
  # including mean here for src2 as a trivial example
  # to show only valid arguments will be in the call
  def_fn = list(define_case, mean),
  fn_args = list(
    vars = list(starts_with("diagx"), "diagx_2"),
    match = "start", # "start" will be applied to all sources as length = 1
    vals = list(c("304"), c("305")),
    clnt_id = "clnt_id",
    # c() can be used in place of list
    # if this argument only takes one value for each source
    n_per_clnt = c(2, 3),
    x = list(1:10) # src2 with mean as def_fn will only accept this argument
  )
)
}
