% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_source.R
\name{bind_source}
\alias{bind_source}
\title{Row-bind a list of data.frames or remote tables}
\usage{
bind_source(data, ..., force_proceed = getOption("healthdb.force_proceed"))
}
\arguments{
\item{data}{A list of data.frame or remote tables, e.g., output from \code{\link[=execute_def]{execute_def()}}.}

\item{...}{Named arguments for each variable included in the output. The argument name should be the new name in the output, and the right hand side of the argument is a character vector of the original names. The name vector and the list elements in \code{data} will be matched by position. if an output variable only came from some of the sources, fill the name vector to a length equal to the number of sources with NA, e.g., \code{var} only come from the second out of three sources, then \code{var = c(NA, 'nm_in_src2', NA)}.}

\item{force_proceed}{A logical for whether to ask for user input in order to proceed when remote tables are needed to be collected for binding. The default is FALSE to let user be aware of that the downloading process may be slow. Use \code{options(healthdb.force_proceed = TRUE)} to suppress the prompt once and for all.}
}
\value{
A data.frame or remote table containing combined rows of the input list with variables specified by ...
}
\description{
Row bind a list of data.frames or remote tables with variable selection and renaming.
}
\examples{
df1 <- subset(iris, Species == "setosa")
df2 <- subset(iris, Species == "versicolor")
df3 <- subset(iris, Species == "virginica")

bind_source(list(df1, df2, df3),
  s_l = "Sepal.Length",
  s_w = "Sepal.Width",
  p_l_setosa = c("Petal.Length", NA, NA),
  p_l_virginica = c(NA, NA, "Petal.Length")
) \%>\%
head()
}
