% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postcode2ste.R
\name{postcode2ste}
\alias{postcode2ste}
\title{In what states do postcodes lie?}
\usage{
postcode2ste(Postcodes, result = c("integer", "character"))
}
\arguments{
\item{Postcodes}{An integer vector of postcodes.}

\item{result}{One of \code{"integer"} or \code{"character"}.
If \code{"character"} the abbreviated state names(s) are returned.}
}
\value{
A vector, the minimal states that cover all postcodes given. For example,
if all postcodes lie within a single state a scalar integer/string of that
state is returned.
}
\description{
While for most postcodes, the state enclosing it
is easy to evaluate (e.g. most postcodes in 2000-2999 are in NSW),
the general case is non-trivial. In particular, some postcodes
straddle state borders.
}
\examples{
vic_poa <- c(3021L, 3084L, 3013L, 3147L, 3030L,
             3123L, 3070L, 3004L, 3250L, 3630L)

postcode2ste(vic_poa)
postcode2ste(vic_poa, result = "character")
postcode2ste(c(vic_poa, 2000L))
postcode2ste(3644L)

}
