% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs-linear-reg.R
\name{ts_wfs_lin_reg}
\alias{ts_wfs_lin_reg}
\title{Linear Regression Workflowset Function}
\usage{
ts_wfs_lin_reg(.model_type, .recipe_list, .penalty = 1, .mixture = 0.5)
}
\arguments{
\item{.model_type}{This is where you will set your engine. It uses
\code{\link[parsnip:linear_reg]{parsnip::linear_reg()}} under the hood and can take one of the following:
\itemize{
\item "lm"
\item "glmnet"
\item "all_engines" - This will make a model spec for all available engines.
}

Not yet implemented are:
\itemize{
\item "stan"
\item "spark"
\item "keras"
}}

\item{.recipe_list}{You must supply a list of recipes. list(rec_1, rec_2, ...)}

\item{.penalty}{The penalty parameter of the glmnet. The default is 1}

\item{.mixture}{The mixture parameter of the glmnet. The default is 0.5}
}
\value{
Returns a workflowsets object.
}
\description{
This function is used to quickly create a workflowsets object.
}
\details{
This function expects to take in the recipes that you want to use in
the modeling process. This is an automated workflow process. There are sensible
defaults set for the \code{glmnet} model specification, but if you choose you can
set them yourself if you have a good understanding of what they should be.
}
\examples{
suppressPackageStartupMessages(library(modeltime))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(healthyR.data))
suppressPackageStartupMessages(library(tidymodels))

data <- healthyR_data \%>\%
 filter(ip_op_flag == "I") \%>\%
   select(visit_end_date_time) \%>\%
   rename(date_col = visit_end_date_time) \%>\%
   summarise_by_time(
       .date_var = date_col
       , .by     = "month"
       , value   = n()
  ) \%>\%
   filter_by_time(
       .date_var     = date_col
       , .start_date = "2012"
       , .end_date   = "2019"
   )

splits <- time_series_split(
   data
  , date_col
  , assess = 12
  , skip = 3
  , cumulative = TRUE
)

rec_objs <- ts_auto_recipe(
 .data = training(splits)
 , .date_col = date_col
 , .pred_col = value
)

wf_sets <- ts_wfs_lin_reg("all_engines", rec_objs)
wf_sets

}
\seealso{
\url{https://workflowsets.tidymodels.org/}(workflowsets)
}
\author{
Steven P. Sanderson II, MPH
}
