% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-vva-plot.R
\name{ts_vva_plot}
\alias{ts_vva_plot}
\title{Time Series Value, Velocity and Acceleration Plot}
\usage{
ts_vva_plot(.data, .date_col, .value_col)
}
\arguments{
\item{.data}{The data you want to visualize. This should be pre-processed and
the aggregation should match the \code{.frequency} argument.}

\item{.date_col}{The data column from the \code{.data} argument.}

\item{.value_col}{The value column from the \code{.data} argument}
}
\value{
The original time series augmented with the differenced data, a static plot
and a plotly plot of the ggplot object. The output is a list that gets returned
invisibly.
}
\description{
This function will produce three plots faceted on a single graph. The three
graphs are the following:
\itemize{
\item Value Plot (Actual values)
\item Value Velocity Plot
\item Value Acceleration Plot
}
}
\details{
This function expects to take in a data.frame/tibble. It will return
a list object that contains the augmented data along with a static plot and
an interactive plotly plot. It is important that the data be prepared and have
at minimum a date column and the value column as they need to be supplied to
the function. If your data is a ts, xts, zoo or mts then use \code{ts_to_tbl()} to
convert it to a tibble.
}
\examples{
suppressPackageStartupMessages(library(dplyr))

data_tbl <- ts_to_tbl(AirPassengers) \%>\%
  select(-index)

ts_vva_plot(data_tbl, date_col, value)$plots$static_plot

}
\author{
Steven P. Sanderson II, MPH
}
