% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gartner_magic_chart.R
\name{gartner_magic_chart_plt}
\alias{gartner_magic_chart_plt}
\title{Gartner Magic Chart - Plotting of two continuous variables}
\usage{
gartner_magic_chart_plt(
  .data,
  .x_col,
  .y_col,
  .point_size_col = NULL,
  .y_lab,
  .x_lab,
  .plt_title,
  .tl_lbl,
  .tr_lbl,
  .br_lbl,
  .bl_lbl
)
}
\arguments{
\item{.data}{The data set you want to plot}

\item{.x_col}{The x-axis for the plot}

\item{.y_col}{The y-axis for the plot}

\item{.point_size_col}{The default is NULL, if you want to size the dots by
a column in the data.frame/tibble then enter the column name here.}

\item{.y_lab}{The y-axis label}

\item{.x_lab}{The x-axis label}

\item{.plt_title}{The title of the plot}

\item{.tl_lbl}{The top left label}

\item{.tr_lbl}{The top right label}

\item{.br_lbl}{The bottom right label}

\item{.bl_lbl}{The bottom left label}
}
\value{
A \code{ggplot} plot
}
\description{
Plot a Gartner Magic Chart of two continuous variables
}
\details{
\itemize{
\item Supply a data frame with at least two continuous variables to plot against
each other
}
}
\examples{
library(dplyr)

data_tbl <- tibble(
    x = rnorm(100, 0, 1),
    y = rnorm(100, 0, 1),
    z = abs(x) + abs(y)
 )

gartner_magic_chart_plt(
  .data = data_tbl,
  .x_col = x,
  .y_col = y,
  .point_size = z,
  .x_lab = "los",
  .y_lab = "ra",
  .plt_title = "tst",
  .tr_lbl = "High RA-LOS",
  .tl_lbl = "High RA",
  .bl_lbl = "Leader",
  .br_lbl = "High LOS"
)

gartner_magic_chart_plt(
  .data = data_tbl,
  .x_col = x,
  .y_col = y,
  .point_size = NULL,
  .x_lab = "los",
  .y_lab = "ra",
  .plt_title = "tst",
  .tr_lbl = "High RA-LOS",
  .tl_lbl = "High RA",
  .bl_lbl = "Leader",
  .br_lbl = "High LOS"
)

}
\author{
Steven P. Sanderson II, MPH
}
