% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{rescale_discount_rate}
\alias{rescale_discount_rate}
\title{Rescale Discount Rate}
\usage{
rescale_discount_rate(x, from, to)
}
\arguments{
\item{x}{Discount rate to rescale.}

\item{from}{Original time period.}

\item{to}{Final time period.}
}
\value{
Rate rescaled under the assumption of compound
discounting.
}
\description{
Rescale a discount rate between two time frames.
}
\details{
Continuous discounting is assumed, i.e. when converting a
long-term discount rate into a short-term rate, we assume
that a partial gain from one short term is
multiplicatively discounted in all following short terms.
At the same time, we assume the short-term rate is
time-invariant.
}
\examples{
  ## 1\% monthly interest rate to annual
  rescale_discount_rate(0.01, 1, 12)
  ## 3\% annual discount rate to (approximately) weekly 
  rescale_discount_rate(0.03, 52, 1)
}
