% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategy_eval.R
\name{expand_if_necessary}
\alias{expand_if_necessary}
\title{Expand States and Transition}
\usage{
expand_if_necessary(strategy, parameters, cycles, init, method, expand_limit,
  inflow, strategy_name)
}
\arguments{
\item{strategy}{An \code{uneval_strategy} object.}

\item{parameters}{Optional. An object generated by
\code{\link[=define_parameters]{define_parameters()}}.}

\item{cycles}{positive integer. Number of Markov Cycles
to compute.}

\item{init}{numeric vector, same length as number of
model states. Number of individuals in each model state
at the beginning.}

\item{method}{Counting method.}

\item{expand_limit}{A named vector of state expansion
limits.}

\item{inflow}{Numeric vector, similar to \code{init}. Number
of new individuals in each state per cycle.}

\item{strategy_name}{Name of the strategy.}
}
\value{
Expanded states, transitions, input and inflow
(if they require expansion; otherwise return inputs
unchanged).
}
\description{
Expand States and Transition
}
\details{
\code{init} need not be integer. E.g. \code{c(A = 1, B = 0.5, C = 0.1, ...)}.
}
\keyword{internal}
