% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_calendar.R
\name{create_calendar}
\alias{create_calendar}
\title{Complete empty calendar}
\usage{
create_calendar(data, key_variable, time_variable, start_year, end_year)
}
\arguments{
\item{data}{R data frame}

\item{key_variable}{character that represents the variable name that refers to the key variable in the panel data (ID, ...)}

\item{time_variable}{character that represents the variable name that permits to sort observation on a time scale}

\item{start_year}{integer of the starting year of the time serie}

\item{end_year}{integer of the ending year of the time serie}
}
\value{
a R data frame with the key and time variable. Each id key is associated with all years between
\code{start_year} and \code{end_year}
}
\description{
This function allows to create a complete empty calendar on a year scale
}
\examples{
rep(c("Paris", "Madrid", "Berlin"), each = 10)
jeu_donnees <- data.frame("country" = rep(c("France", "Spain", "Germany"), each = 10),
"capital" = rep(c("Paris", "Madrid", "Berlin"), each = 10),
"year" = 2009:2018,
"gdp" = c(NA, NA, 200, 300, 500, 1000, NA, NA, NA, 500,
 0, NA, NA, NA, NA, NA, NA, 800, 1200, 1500,
 100, 200, 400, 700, 700, 800, 600, 500, NA, NA))
 jeu_donnees <- na.omit(jeu_donnees)# we artificially create some gaps in the time series
 data_1 <- create_calendar(data = jeu_donnees, key_variable = "country", time_variable = "year",
 start_year = 2009, end_year = 2018)
 data_2 <- start_end_to_fill(data = jeu_donnees, calendar = data_1, gap_variable = "gdp",
 key_variable = "country", time_variable = "year")
 data_3 <- gap_to_fill(data = data_2, gap_variable = "gdp_corrected_1", key_variable = "country",
 time_variable = "year", digits = 1)
}
\references{
Link to the author's github package repository:
\url{https://www.github.com/Redcart/helda}
}
\author{
Simon CORDE
}
\keyword{calendar}
\keyword{fill}
\keyword{gaps}
\keyword{series}
\keyword{time}
