\name{mcmc.diagnostics}

\alias{mcmc.diagnostics}

\alias{hergm.mcmc.diagnostics}

\alias{mcmc.diagnostics.hergm}

\title{MCMC diagnostics of objects of class \code{hergm}}

\description{

The function \code{mcmc.diagnostics} helps detect non-convergence of the auxiliary-variable MCMC algorithm implemented in function \code{hergm}.
It reports Markov chain Monte Carlo convergence diagnostics by using the function \code{mcgibbsit} of \code{R} package \code{mcgibbsit} along with trace plots.
The help function of the function \code{mcgibbsit} provides additional details about the output of the function \code{mcgibbsit}.

}

\usage{

\method{mcmc.diagnostics}{hergm}(object, \dots)

}

\arguments{

\item{object}{object of class \code{hergm}; objects of class \code{hergm} can be generated by function \code{hergm}.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\value{

The function \code{mcmc.diagnostics} returns a list with the following components:

\item{mcmc.alpha}{MCMC diagnostics for the concentration parameter of truncated Dirichlet process prior of parameters of \code{hergm-terms}.}

\item{mcmc.eta_mean}{MCMC diagnostics for the mean parameters of Gaussian base distribution of parameters of \code{hergm-terms}.}

\item{mcmc.eta_precision}{MCMC diagnostics for the precision parameters of Gaussian base distribution of parameters of \code{hergm-terms}.}

\item{mcmc.ergm_theta}{MCMC diagnostics for the parameters of \code{ergm-terms}.}

\item{mcmc.hergm_theta}{MCMC diagnostics for the parameters of \code{hergm-terms}.}

}

\seealso{hergm}

\examples{
\dontrun{data(example)
object <- hergm(d ~ edges_ij + triangle_ijk)
mcmc.diagnostics(object)
}
}

