% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.sts.R
\name{as.sts}
\alias{as.sts}
\alias{sts}
\alias{as_sts}
\title{Convert object to \code{sts} class}
\usage{
as.sts(x)

sts(x)

as_sts(x)
}
\arguments{
\item{x}{A matrix-like object with 2 dimensions or an
array with 3 dimensions.}
}
\value{
An \code{sts} object.
}
\description{
Convert a numeric three-dimensional \code{array} or
two-dimensional matrix-like object to an
\code{sts} (spatial time series) object.  If \code{x} is
a three-dimensional array, the first two dimensions are
assumed to relate to gridded spatial positions.  If
\code{x} has only two dimensions, each row is a time
series for a specific location.  Each column is a
realization of a geostatistical process at a specific
time.
}
\details{
This method has been tested with objects of class
\code{\link{matrix}}, \code{\link{data.frame}},
\code{\link{array}}, and
\code{\link[Matrix]{Matrix-class}}.  It should be
possible for \code{x} to have a different class as long
as the object has a loaded \code{\link{as.matrix}}
method, which is used in this function.
}
\examples{
# 3d array to sts
sts = as.sts(tasmax)
class(sts)

# extract a subset of tasmax to produce an sts
x = matrix(c(tasmax[50:60, 50:60, ]), ncol = 30)
sts = as.sts(x)
class(sts)

sts = as.sts(as.array(x))
class(sts)

sts = as.sts(Matrix::Matrix(x))
class(sts)

sts = as.sts(as.data.frame(x))
class(sts)
}
