% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand.R
\name{rdirichlet_mat}
\alias{rdirichlet_mat}
\title{Random generation for multiple Dirichlet distributions}
\usage{
rdirichlet_mat(n, alpha)
}
\arguments{
\item{n}{Number of samples to draw.}

\item{alpha}{A matrix where each row is a separate vector of shape parameters.}
}
\value{
An array of matrices where each row of each matrix is a sample from the Dirichlet distribution.
}
\description{
Draw random samples from multiple Dirichlet distributions.
\code{rdirichlet_mat} is vectorized and written in C++ for speed.
}
\details{
This function is particularly useful for representing the distribution of 
transition probabilities in a transition matrix.
}
\examples{
alpha <- matrix(c(100, 200, 500, 50, 70, 75), ncol = 3, nrow = 2, byrow = TRUE)
samp <- rdirichlet_mat(100, alpha)
print(samp[, , 1:2])
}
