% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_def.R
\name{define_rng}
\alias{define_rng}
\alias{eval_rng}
\title{Define and evaluate random number generation expressions}
\usage{
define_rng(expr, n = 1, ...)

eval_rng(x, params = NULL)
}
\arguments{
\item{expr}{An expression used to randomly draw variates for each parameter of
interest in the model. \link[base:Paren]{Braces} should be used so that the result
of the last expression within the braces is evaluated. The expression must
return a list where each element is either a \code{vector}, \code{matrix}, \code{data.frame},
or \code{data.table}. The length of
the \code{vector} and number of rows in the \code{matrix}/\code{data.frame}/\code{data.table},
must either be 1 or \code{n}.}

\item{n}{Number of samples of the parameters to draw.}

\item{...}{Additional arguments to pass to the environment used to evaluate
\code{expr}.}

\item{x}{An object of class \code{rng_def} created with \code{define_rng()}.}

\item{params}{A list containing the values of parameters for random number
generation. Each element of the list should either be a \code{vector},
\code{matrix}, \code{data.frame}, or \code{data.table}}
}
\value{
\code{define_rng()} returns an object of class \code{rng_def},
which is a list containing the unevaluated random number generation
expressions passed  to \code{expr}, \code{n}, and any additional arguments passed to
\code{...} . \code{eval_rng()} evaluates the \code{rng_def} object and should return a list.
}
\description{
Random number generation expressions are used to
randomly sample model parameters from suitable distributions for probabilistic
sensitivity analysis. These functions are typically used when evaluating
an object of class \code{model_def} defined using \code{\link[=define_model]{define_model()}}.
}
\details{
\code{hesim} contains a number of random number generation functions
that return parameter samples in convenient formats
and do not require the number of samples, \code{n}, as arguments
(see \link{rng_distributions}). The random number generation expressions
are evaluated using \code{eval_rng()} and used within \code{expr}
in \code{define_rng()}. If multivariate object is returned by \code{eval_rng()},
then the rows are random samples and columns are
distinct parameters (e.g., costs for each health state, elements of a
transition probability matrix).
}
\examples{
 
params <- list(
  alpha = matrix(c(75, 25, 33, 67), byrow = TRUE, ncol = 2),
  inptcost_mean = c(A = 900, B = 1500, C = 2000),
  outptcost_mean = matrix(c(300, 600, 800,
                            400, 700, 700),
                           ncol = 3, byrow = TRUE)
)
rng_def <- define_rng({
  aecost_mean <- c(500, 800, 1000) # Local object not 
                                   # not returned by eval_rng()
  list( # Sampled values of parameters returned by eval_rng()
    p = dirichlet_rng(alpha), # Default column names
    inptcost = gamma_rng(mean = inptcost_mean, # Column names based on 
                         sd = inptcost_mean),  # named vector
    outptcost = outptcost_mean, # No column names because
                                # outptcost_mean has none.
    aecost = gamma_rng(mean = aecost_mean, # Explicit naming of columns
                       sd = aecost_mean,
                       names = aecost_colnames)
  )
}, n = 2, aecost_colnames = c("A", "B", "C")) # Add aecost_colnames to environment
eval_rng(x = rng_def, params)
}
\seealso{
\link{rng_distributions}, \code{\link[=define_model]{define_model()}}, \code{\link[=define_tparams]{define_tparams()}}
}
