% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{tparams_mean}
\alias{tparams_mean}
\title{Predicted means}
\usage{
tparams_mean(value, ...)
}
\arguments{
\item{value}{Matrix of samples from the distribution of the
mean. Columns denote random samples and rows denote means for different observations.}

\item{...}{Arguments to pass to \link{id_attributes}. Each row in
\code{value} must be a prediction for a \code{strategy_id},
\code{patient_id}, \code{state_id}, and optionally \code{time_id} combination.}
}
\value{
An object of class \code{tparams_mean}, which is a list containing \code{value},
\code{n_samples}, and the ID attributes passed to \link{id_attributes}.
}
\description{
Create a list containing means predicted from a statistical model.
}
\examples{
tparams_mean(value = matrix(1:8, nrow = 4),
             strategy_id = rep(1:2, each = 2),
             n_strategies = 2,
             patient_id = rep(1, 4),
             n_patients = 1,
             state_id = rep(1:2, times = 2),
             n_states = 2)

}
\seealso{
\link{tparams}
}
