% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{tparams_transprobs}
\alias{tparams_transprobs}
\alias{tparams_transprobs.array}
\alias{tparams_transprobs.data.table}
\alias{tparams_transprobs.data.frame}
\title{Transition probabilities}
\usage{
tparams_transprobs(object, ...)

\method{tparams_transprobs}{array}(object, times = NULL, grp_id = NULL, patient_wt = NULL)

\method{tparams_transprobs}{data.table}(object)

\method{tparams_transprobs}{data.frame}(object)
}
\arguments{
\item{object}{An object of the appropriate class.}

\item{...}{Further arguments passed to or from other methods. Currently unused.}

\item{times}{An optional numeric vector of distinct times to pass to
\link{time_intervals} representing time intervals indexed by the 4th dimension of
the array. May either be the start or the end of intervals.
This argument is not required if there is only one time interval.}

\item{grp_id}{An optional numeric vector of integers denoting the subgroups. Must
be the same length as the 3rd dimension of the array.}

\item{patient_wt}{An optional numer vector denoting the weight to apply to each
patient within a subgroup. Must be the same length as the 3rd dimension of the array.}
}
\value{
An object of class \code{tparams_transprobs},
which is a list containing \code{value} and relevant ID attributes. The element \code{value} is an
array of predicted transition probability matrices from the probability
distribution of the underlying statistical model. Each matrix in
\code{value} is a prediction for a \code{sample}, \code{strategy_id},
\code{patient_id}, and optionally \code{time_id} combination.
}
\description{
Create a list containing predicted transition probabilities at discrete times.
Since the transition probabilities have presumably
already been predicted based on covariate values, no input data is required for
simulation. The class can be instantiated from either an array, a data table, or
a data frame.
}
\details{
The format of \code{object} depends on its class:
\describe{
\item{array}{Must be a 4D array of matrices (i.e.,
a 6D array). The dimensions of the array should be indexed as follows:
1st (\code{sample}), 2nd (\code{strategy_id}), 3rd (\code{patient_id}),
4th (\code{time_id}), 5th (rows of transition matrix), and
6th (columns of transition matrix). In other words, an index of
\verb{[s, k, i, t]} represents the transition matrix for the \code{s}th
sample, \code{k}th treatment strategy, \code{i}th patient, and \code{t}th
time interval.}
\item{data.table}{Must contain the following:
\itemize{
\item ID columns for the parameter sample (\code{sample}),
treatment strategy (\code{strategy_id}), and patient (\code{patient_id}).
If the number of time intervals is greater than 1 it must also contain the
column \code{time_start} denoting the starting time of a time interval. A column
\code{patient_wt} may also be used to denote the weight to apply to each
patient.
\item Columns for each element of the transition probability matrix.
They should be prefixed with "probs_" and ordered rowwise.
For example, the following columns would be used for a 2x2 transition
probability matrix:
\code{probs_1} (1st row, 1st column),
\code{probs_2} (1st row, 2nd column),
\code{probs_3} (2nd row, 1st column), and
\code{probs_4} (2nd row, 2nd column).
}
}
\item{data.frame}{Same as \code{data.table}.}
}

A \code{tparams_transprobs} object is also instantiated when creating a
cohort discrete time state transition model using \code{\link[=define_model]{define_model()}}.
}
\seealso{
\code{\link[=define_model]{define_model()}}, \code{\link[=create_CohortDtstm]{create_CohortDtstm()}}
}
