% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statevals.R
\name{create_StateVals}
\alias{create_StateVals}
\alias{create_StateVals.lm}
\alias{create_StateVals.stateval_tbl}
\title{Create a \code{StateVals} object}
\usage{
create_StateVals(object, ...)

\method{create_StateVals}{lm}(
  object,
  input_data = NULL,
  n = 1000,
  point_estimate = FALSE,
  ...
)

\method{create_StateVals}{stateval_tbl}(object, n = 1000, ...)
}
\arguments{
\item{object}{A model object of the appropriate class.}

\item{...}{Further arguments (\code{time_reset} and \code{method}) passed to \link[=StateVals]{StateVals$new()}.}

\item{input_data}{An object of class \link[=expand.hesim_data]{expanded_hesim_data}.
Must be expanded by treatment strategies, patients, and health states.}

\item{n}{Number of random observations of the parameters to draw when parameters
are fit using a statistical model.}

\item{point_estimate}{If \code{TRUE}, then the point estimates are returned and and no samples are drawn.}
}
\value{
A \link{StateVals} object.
}
\description{
\code{create_StateVals()} is a generic function for creating an object of class
\link{StateVals} from a fitted statistical model or a \link{stateval_tbl}
object.
}
\seealso{
\link{StateVals}, \link{stateval_tbl}
}
