% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtstm.R
\name{CohortDtstmTrans}
\alias{CohortDtstmTrans}
\title{Transitions for a cohort discrete time state transition model}
\format{
An \link[R6:R6Class]{R6::R6Class} object.
}
\description{
Simulate health state transitions in a cohort discrete time state transition model.
}
\examples{
library("msm")
library("data.table")
set.seed(101)

# Model setup
strategies <- data.table(
  strategy_id = c(1, 2, 3),
  strategy_name = c("SOC", "New 1", "New 2")
)
patients <- data.table(patient_id = 1:2)
hesim_dat <- hesim_data(
  strategies = strategies,
  patients = patients
)
  

# Fit multi-state model with panel data via msm
qinit <- rbind(
  c(0, 0.28163, 0.01239),
  c(0, 0, 0.10204),
  c(0, 0, 0)
)
fit <- msm(state_id ~ time, subject = patient_id, 
           data = onc3p[patient_id \%in\% sample(patient_id, 100)],
           covariates = list("1-2" =~ strategy_name), 
           qmatrix = qinit)

# Simulation model
transmod_data <- expand(hesim_dat)
transmod <- create_CohortDtstmTrans(fit,
                                    input_data = transmod_data,
                                    cycle_length = 1/2,
                                    fixedpars = 2,
                                    n = 2)
transmod$sim_stateprobs(n_cycles = 2)
}
\seealso{
\code{\link[=create_CohortDtstmTrans]{create_CohortDtstmTrans()}}, \link{CohortDtstm}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{params}}{Parameters for simulating health state transitions.
Supports objects of class \code{\link{tparams_transprobs}} or \code{\link{params_mlogit}}.}

\item{\code{input_data}}{An object of class \code{\link{input_mats}}.}

\item{\code{cycle_length}}{The length of a model cycle in terms of years.
The default is \code{1} meaning that model cycles are 1 year long.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{start_stateprobs}}{A non-negative vector with length equal to the number of
health states containing the probability that the cohort is in each health
state at the start of the simulation. For example,
if there were three states and the cohort began the simulation in state 1,
then \code{start_stateprobs = c(1, 0, 0)}. Automatically normalized to sum to 1.
If \code{NULL}, then a vector with the first element equal to 1 and
all remaining elements equal to 0.}

\item{\code{trans_mat}}{A transition matrix describing the states and transitions
in a discrete-time multi-state model. Only required if the model is
parameterized using multinomial logistic regression. The \verb{(i,j)} element
represents a transition from state \code{i} to state \code{j}. Each possible transition
from row \code{i} should be based on a separate multinomial logistic regression
and ordered from \code{0} to \code{K - 1} where \code{K} is the number of
possible transitions. Transitions that are not possible should be \code{NA}.
and the reference category for each row should be \code{0}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{CohortDtstmTrans$new()}}
\item \href{#method-sim_stateprobs}{\code{CohortDtstmTrans$sim_stateprobs()}}
\item \href{#method-clone}{\code{CohortDtstmTrans$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{CohortDtstmTrans} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CohortDtstmTrans$new(
  params,
  input_data = NULL,
  trans_mat = NULL,
  start_stateprobs = NULL,
  cycle_length = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{The \code{params} field.}

\item{\code{input_data}}{The \code{input_data} field.}

\item{\code{trans_mat}}{The \code{trans_mat} field.}

\item{\code{start_stateprobs}}{The \code{start_stateprobs} field.}

\item{\code{cycle_length}}{The \code{cycle_length} field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{CohortDtstmTrans} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sim_stateprobs"></a>}}
\if{latex}{\out{\hypertarget{method-sim_stateprobs}{}}}
\subsection{Method \code{sim_stateprobs()}}{
Simulate probability of being in each health state during each model cycle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CohortDtstmTrans$sim_stateprobs(n_cycles)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_cycles}}{The number of model cycles to simulate the model for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{stateprobs}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CohortDtstmTrans$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
