% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_def.R
\name{summary.eval_rng}
\alias{summary.eval_rng}
\alias{print.eval_rng}
\title{Summarize \code{eval_rng} object}
\usage{
\method{summary}{eval_rng}(object, probs = c(0.025, 0.975), sep = "_", ...)

\method{print}{eval_rng}(x, ...)
}
\arguments{
\item{object, x}{An \code{\link{eval_rng}} object.}

\item{probs}{A numeric vector of probabilities with values in \verb{[0,1]} used to
compute quantiles with \code{\link[stats:quantile]{stats::quantile()}}.}

\item{sep}{When a list element returned by \code{eval_rng} is a tabular object,
the parameter name is created by concatenating the name of the list element
with the columns of the tabular object. The \code{sep} argument determines the
character string used to separate the terms.}

\item{...}{For the print method, arguments to pass to \code{summary.eval_rng()}.}
}
\value{
\code{summary.eval_rng()} returns a \code{\link{data.table}} with columns for
(i) the name of the parameter (\code{param}), (ii) the mean of the parameter
samples (\code{mean}), (iii) the standard deviation of the parameter samples (\code{sd}),
and (iv) quantiles of the parameter samples corresponding
to the \code{probs} argument. \code{print.eval_rng()} prints the output of
\code{summary.eval_rng()} to the console.
}
\description{
Summarize the model parameters randomly sampled for probabilistic sensitivity
analysis with \code{\link[=eval_rng]{eval_rng()}}.
}
\seealso{
See \code{\link[=eval_rng]{eval_rng()}} for an example.
}
