% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetu_control_char.R
\name{hetu_control_char}
\alias{hetu_control_char}
\title{Calculate Control Character for Personal Identity Code}
\usage{
hetu_control_char(pin, with.century = TRUE)
}
\arguments{
\item{pin}{An incomplete PIN that ONLY has a date, century marker (optional,
see parameter with.century) and personal number}

\item{with.century}{If TRUE (default), the function assumes that the PIN
input contains a century marker (DDMMYYQZZZ). If FALSE, the function
assumes that the PIN contains only date and personal number (DDMMYYZZZ).}
}
\value{
Control character, either a number 0-9 or a letter.
}
\description{
Calculate a valid control character for an incomplete
   Finnish personal identity codes (hetu).
}
\details{
This method of calculating the control character was devised by
   mathematician Erkki Pale (1962) to detect input errors but also to
   detect errors produced by early punch card machines. The long number
   produced by writing the birth date and the personal number together are
   divided by 31 and the remainder is used to look up the control character
   from a separate table containing alphanumeric characters except letters
   G, I, O, Q and Z.

   The method of calculating the control character does not need century
   character and therefore the function has an option to omit it.
}
\examples{
hetu_control_char("010101-010")
hetu_control_char("010101010", with.century = FALSE)
}
\seealso{
\code{\link{hetu}} For extracting information from Finnish personal
   identity codes.
}
\author{
Pyry Kantanen
}
