% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_date.R
\name{pin_date}
\alias{pin_date}
\alias{hetu_date}
\title{Extract Date of Birth from Personal Identity Code}
\usage{
pin_date(pin, allow.temp = FALSE)

hetu_date(pin, allow.temp = FALSE)
}
\arguments{
\item{pin}{Finnish personal identity code(s) as a character vector}

\item{allow.temp}{Allow artificial or temporary PINs (personal numbers
900-999). If \code{FALSE} (default), only PINs intended for official
use (personal numbers 002-899) are allowed.}
}
\value{
Date of birth as a vector in date format.
}
\description{
Returns the date of birth in date format.
}
\examples{
pin_date(c("010101-0101", "111111-111C"))

hetu_date(c("010101-0101", "111111-111C"))
}
