% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additive-reg-mstep.R
\name{additive_reg_mstep}
\alias{additive_reg_mstep}
\title{the M step function of the EM algorithm}
\usage{
additive_reg_mstep(x, wt, control = list(K = 5, lambda0 = 0.01, resp.ind = 1))
}
\arguments{
\item{x}{the observation matrix}

\item{wt}{the state probabilities matrix (number of observations
times number of states)}

\item{control}{the parameters to control the M-step function.
The simillar name is chosen with that of \code{\link{dnorm_additive_reg}},
to be used in \code{...} argument of the \code{\link{hhsmmfit}} function.
Here, it contains the following items:
\itemize{
\item \code{K}{ the degrees of freedom for the B-spline, default is \code{K=5}}
\item \code{lambda0}{ the initial value of the smoothing parameter, default is \code{lambda0=0.01}}
\item \code{resp.ind}{ a vector of the column numbers of \code{x} which contain response variables. 
The default is 1, which means that the first column of \code{x} is the univariate 
response variable}
}}
}
\value{
list of emission (nonparametric mixture of splines) parameters:
}
\description{
The M step function of the EM algorithm for the Gaussian linear (Markov-switching) regression
as the emission distribution using the
responses and covariates matrices and the estimated weight vectors
}
\examples{
J <- 3
initial <- c(1, 0, 0)
semi <- rep(FALSE, 3)
P <- matrix(c(0.5, 0.2, 0.3, 0.2, 0.5, 0.3, 0.1, 0.4, 0.5), nrow = J, 
byrow = TRUE)
par <- list(intercept = list(3, list(-10, -1), 14),
coefficient = list(-1, list(1, 5), -7),
csigma = list(1.2, list(2.3, 3.4), 1.1),
mix.p = list(1, c(0.4, 0.6), 1))
model <- hhsmmspec(init = initial, transition = P, parms.emis = par,
dens.emis = dmixlm, semi = semi)
train <- simulate(model, nsim = c(20, 30, 42, 50), seed = 1234, 
remission = rmixlm, covar = list(mean = 0, cov = 1))
clus = initial_cluster(train = train, nstate = 3, nmix = NULL,
ltr = FALSE, final.absorb = FALSE, verbose = TRUE, regress = TRUE)
initmodel = initialize_model(clus = clus ,mstep = additive_reg_mstep,
dens.emission = dnorm_additive_reg, sojourn = NULL, semi = rep(FALSE, 3),
M = max(train$N),verbose = TRUE)
fit1 = hhsmmfit(x = train, model = initmodel, mstep = additive_reg_mstep,
M = max(train$N))
plot(train$x[, 1] ~ train$x[, 2], col = train$s, pch = fit1$yhat, 
xlab = "x", ylab = "y")
text(0,30, "colors are real states",col="red")
text(0,28, "characters are predicted states")
library(splines2)
basis = bSpline(train$x[, 2], df = 5, Boundary.knots = 
                  c(min(train$x[, 2]) - 0.01, max(train$x[, 2]) + 0.01))
yhat1 = fit1$model$parms.emission$intercept[[1]][1] + 
basis \%*\% fit1$model$parms.emission$coef[[1]][,1,1]
yhat2 = fit1$model$parms.emission$intercept[[2]][1] + 
basis \%*\% fit1$model$parms.emission$coef[[2]][,1,1]
yhat3 = fit1$model$parms.emission$intercept[[3]][1] + 
basis \%*\% fit1$model$parms.emission$coef[[3]][,1,1]

lines(yhat1[order(train$x[, 2])]~sort(train$x[, 2]),col = 2)
lines(yhat2[order(train$x[, 2])]~sort(train$x[, 2]),col = 1)
lines(yhat3[order(train$x[, 2])]~sort(train$x[, 2]),col = 3)

}
\references{
Langrock, R., Adam, T., Leos-Barajas, V.,
Mews, S., Miller, D. L., and Papastamatiou, Y. P. (2018).
Spline-based nonparametric inference in general state-switching models.
Statistica Neerlandica, 72(3), 179-200.
}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir},
Reza Salehian,  \email{reza.salehian@ut.ac.ir}
}
