% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial-estimate.R
\name{initial_estimate}
\alias{initial_estimate}
\title{initial estimation of the model parameters for a specified emission distribution}
\usage{
initial_estimate(clus, mstep = mixmvnorm_mstep, verbose = FALSE, ...)
}
\arguments{
\item{clus}{an initial clustering obtained by \code{initial_cluster}}

\item{mstep}{the mstep function of the EM algorithm with an style simillar to that of \code{\link{mixmvnorm_mstep}}}

\item{verbose}{logical. if TRUE the outputs will be printed}

\item{...}{additional parameters of the \code{mstep} function}
}
\value{
a list containing the following items:
\itemize{
\item \code{emission}{ list the estimated parameterers of the emission distribution}
\item \code{leng}{ list of waiting times in each state for each sequence}
\item \code{clusters}{ the exact clusters of each observation (available if \code{ltr}=FALSE)}
\item \code{nmix}{ the number of mixture components (a vector of positive (non-zero) integers of length \code{nstate})}
\item \code{ltr}{ logical. if TRUE a left to right hidden hybrid Markovian/semi-Markovianmodel is assumed}
}
}
\description{
Provides the initial estimates of the model parameters of a specified emission
distribution characterized by the \code{mstep} function, for an initial clustering
obtained by \code{\link{initial_cluster}}
}
\examples{
J <- 3
initial <- c(1, 0, 0)
semi <- c(FALSE, TRUE, FALSE)
P <- matrix(c(0.8, 0.1, 0.1, 0.5, 0, 0.5, 0.1, 0.2, 0.7), nrow = J, 
byrow = TRUE)
par <- list(mu = list(list(7, 8), list(10, 9, 11), list(12, 14)),
sigma = list(list(3.8, 4.9), list(4.3, 4.2, 5.4), list(4.5, 6.1)),
mix.p = list(c(0.3, 0.7), c(0.2, 0.3, 0.5), c(0.5, 0.5)))
sojourn <- list(shape = c(0, 3, 0), scale = c(0, 10, 0), type = "gamma")
model <- hhsmmspec(init = initial, transition = P, parms.emis = par,
dens.emis = dmixmvnorm, sojourn = sojourn, semi = semi)
train <- simulate(model, nsim = c(10, 8, 8, 18), seed = 1234, 
remission = rmixmvnorm)
clus = initial_cluster(train, nstate = 3, nmix = c(2 ,2, 2),ltr = FALSE,
final.absorb = FALSE, verbose = TRUE)
par = initial_estimate(clus, verbose = TRUE)

}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}, Afarin Bayat,  \email{aftbayat@gmail.com}
}
