\name{FTGramImage}
\alias{FTGramImage}
\title{Display Fourier spectrogram}
\description{
This function displays a Fourier spectrogram using the same plot structure and options as \code{\link{HHGramImage}}.
It uses the function \code{\link{EvolutiveFFT}} to generate a spectrogram, then wraps it in the same plotting format as \code{\link{HHGramImage}}.
}
\usage{
FTGramImage(sig, dt, ft, time.span = NULL, freq.span = NULL, 
     amp.span = NULL, blur = NULL, taper=0.05, scaling = "none", grid=TRUE, 
    colorbar=TRUE, backcol=c(0, 0, 0), colormap=NULL, pretty=FALSE, ...)
}
\arguments{
\item{sig}{The signal to process}
\item{dt}{sample rate}
\item{ft}{Fourier spectrogram options}
\itemize{
    \item{\code{ft$nfft} is the fft length}
    \item{\code{ft$ns} is the number of samples in a window}
    \item{\code{ft$nov} is the number of samples to overlap}}
\item{time.span}{Time span to render spectrogram over.  \code{NULL} will draw the spectrogram over the entire signal.}
\item{freq.span}{Frequency span to render spectrogram over.  \code{NULL} plots everything up to the Nyquist frequency.}
\item{amp.span}{Amplitude range to plot.  \code{NULL} plots everything.}
\item{blur}{Apply a Gaussian smoother.  Default \code{NULL} - no smoothing}.
\itemize{
    \item{\code{blur$sigma} is a scalar or two-element vector giving the standard deviation of the Gaussian kernel.}
    \item{\code{blur$bleed} determines whether to allow values to bleed out of the domain of the image.  Default \code{TRUE}}}
\item{taper}{Taper value to use for spectrogram (default is 0.05), see \code{spec.taper} in the \code{base} package.}
\item{scaling}{determines whether to apply logarithmic (log), or square root (sqrt) scaling to the amplitude data}
\item{grid}{Boolean - whether to display grid lines or not}
\item{colorbar}{Boolean - whether to display amplitude colorbar or not}
\item{backcol}{What background color to use behind the spectrogram, in a 3 element vector: \code{c(red, green, blue)}}
\item{colormap}{What palette object to use for the spectrogram, defaults to \code{rainbow}}
\item{pretty}{Boolean - choose nice axes values, some adjustment may result}
\item{\dots}{This function supports some optional parameters as well:
\itemize{
    \item{trace.format}{ - the format of the trace minima and maxima in sprintf format}
    \item{img.x.format}{ - the format of the X axis labels of the image in sprintf format}
    \item{img.y.format}{ - the format of the Y axis labels of the image in sprintf format}
    \item{colorbar.format}{ - the format of the colorbar labels in sprintf format}
    \item{cex.lab}{ - the font size of the image axis labels}
    \item{cex.colorbar}{ - the font size of the colorbar}
    \item{cex.trace}{ - the font size of the trace axis labels}
    \item{img.x.lab}{ - the X - axis label of the image, it defaults to "time"}
    \item{img.y.lab}{- the Y - axis label of the image, it defaults to "frequency"}
    \item{main}{ - figure title}}}
}

\details{
This function is a simple Fourier spectrogram plotter.
It's useful to compare this image with images generated by \code{\link{HHGramImage}} to see how the Fourier and Hilbert spectrograms differ.
}
\value{
\item{img}{The spectrogram image, suitable for plotting with the generic \code{image} function}
}
\references{Jonathan M. Lees (2012). RSEIS: Seismic Time Series Analysis Tools. R
  package version 3.0-6. http://CRAN.R-project.org/package=RSEIS}

\author{Daniel Bowman \email{danny.c.bowman@gmail.com}}

\seealso{
\code{\link{HHGramImage}}, \code{\link{EvolutiveFFT}}
}
\examples{
data(PortFosterEvent)

dt <- mean(diff(tt))

ft <- list()
ft$nfft <- 4096
ft$ns <- 30
ft$nov <- 29

time.span <- c(5, 10)
freq.span <- c(0, 25)
amp.span <- c(1e-5, 0.0003)
FTGramImage(sig, dt, ft, time.span = time.span, freq.span = freq.span, 
    amp.span = amp.span, pretty = TRUE, img.x.format = "\%.1f",
    img.y.format = "\%.0f",
    main = "Port Foster Event - Fourier Spectrogram")
}

\keyword{ts}
\keyword{hplot}
