% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbayes.r
\name{sbayes}
\alias{sbayes}
\title{SBayes model}
\usage{
sbayes(
  sumstat,
  ldm,
  model = c("BayesB", "BayesA", "BayesL", "BayesRR", "BayesBpi", "BayesC", "BayesCpi",
    "BayesR", "CG"),
  map = NULL,
  Pi = NULL,
  lambda = NULL,
  fold = NULL,
  niter = 20000,
  nburn = 14000,
  windsize = NULL,
  wppa = 0.01,
  vg = NULL,
  dfvg = NULL,
  s2vg = NULL,
  ve = NULL,
  dfve = NULL,
  s2ve = NULL,
  outfreq = 100,
  seed = 666666,
  threads = 4,
  verbose = TRUE
)
}
\arguments{
\item{sumstat}{matrix of summary data, details refer to https://cnsgenomics.com/software/gcta/#COJO.}

\item{ldm}{dense or sparse matrix, ld for reference panel (m * m, m is the number of SNPs). NOTE that the order of SNPs should be consistent with summary data.}

\item{model}{bayes model including: "BayesB", "BayesA", "BayesL", "BayesRR", "BayesBpi", "BayesC", "BayesCpi", "BayesR", "CG".
\itemize{
\item "BayesRR": Bayes Ridge Regression, all SNPs have non-zero effects and share the same variance, equals to RRBLUP or GBLUP.
\item "BayesA": all SNPs have non-zero effects, and take different variance which follows an inverse chi-square distribution.
\item "BayesB": only a small proportion of SNPs (1-Pi) have non-zero effects, and take different variance which follows an inverse chi-square distribution.
\item "BayesBpi": the same with "BayesB", but 'Pi' is not fixed.
\item "BayesC": only a small proportion of SNPs (1-Pi) have non-zero effects, and share the same variance.
\item "BayesCpi": the same with "BayesC", but 'Pi' is not fixed.
\item "BayesL": BayesLASSO, all SNPs have non-zero effects, and take different variance which follows an exponential distribution.
\item "BayesR": only a small proportion of SNPs have non-zero effects, and the SNPs are allocated into different groups, each group has the same variance.
\item "CG": conjugate gradient algorithm with assigned lambda.
}}

\item{map}{(optional, only for GWAS) the map information of genotype, at least 3 columns are: SNPs, chromosome, physical position.}

\item{Pi}{vector, the proportion of zero effect and non-zero effect SNPs, the first value must be the proportion of non-effect markers.}

\item{lambda}{value or vector, the ridge regression value for each SNPs.}

\item{fold}{percentage of variance explained for groups of SNPs, the default is c(0, 0.0001, 0.001, 0.01).}

\item{niter}{the number of MCMC iteration.}

\item{nburn}{the number of iterations to be discarded.}

\item{windsize}{window size in bp for GWAS, the default is 1e6.}

\item{wppa}{the threshold of genetic variance explained by single window, the default is 0.01.}

\item{vg}{prior value of genetic variance.}

\item{dfvg}{the number of degrees of freedom for the distribution of genetic variance.}

\item{s2vg}{scale parameter for the distribution of genetic variance.}

\item{ve}{prior value of residual variance.}

\item{dfve}{the number of degrees of freedom for the distribution of residual variance.}

\item{s2ve}{scale parameter for the distribution of residual variance.}

\item{outfreq}{frequency of information output on console, the default is 100.}

\item{seed}{seed for random sample.}

\item{threads}{number of threads used for OpenMP.}

\item{verbose}{whether to print the iteration information.}
}
\value{
the function returns a list containing
\describe{
\item{$pi}{estimated proportion of zero effect and non-zero effect SNPs}
\item{$vg}{estimated genetic variance}
\item{$ve}{estimated residual variance}
\item{$alpha}{estimated effect size of all markers}
\item{$modfreq}{the frequency for markers to be included in the model during MCMC iteration, also known as posterior inclusive probability (PIP)}
\item{$gwas}{WPPA is defined to be the window posterior probability of association, it is the ratio of the number of iterations that \eqn{Pw} (the proportion of the total genetic variance explained by the window \eqn{w}) > 1\% divided by the total number of MCMC iterations, WGVE is the explained genetic variance for each window}
}
}
\description{
Bayes linear regression model using summary level data
}
\examples{
bfile_path = system.file("extdata", "geno", package = "hibayes")
data = read_plink(bfile_path, out=tempfile())
geno = data$geno
map = data$map
head(map)
sumstat_path = system.file("extdata", "geno.ma", package = "hibayes")
sumstat = read.table(sumstat_path, header=TRUE)
head(sumstat)
\donttest{
# computate ld variance covariance matrix
ldm1 = ldmat(geno, threads=4)   #chromosome wide full ld matrix

# if the order of SNPs in genotype is not consistent with the order in sumstat file, 
# prior adjusting is necessary.
indx = match(map[, 1], sumstat[, 1])
sumstat = sumstat[indx, indx]

# fit model
fit = sbayes(sumstat=sumstat, ldm=ldm1, model="BayesR")
}

}
\references{
Lloyd-Jones, Luke R., et al. "Improved polygenic prediction by Bayesian multiple regression on summary statistics." Nature communications 10.1 (2019): 1-11.
}
