% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{hc_theme}
\alias{hc_theme}
\title{Highchart theme constructor}
\usage{
hc_theme(...)
}
\arguments{
\item{...}{A named list with the parameters.}
}
\description{
Function to create highcharts themes.
}
\details{
More examples are in http://www.highcharts.com/docs/chart-design-and-style/themes.
}
\examples{

hc <- highchart(debug = TRUE) \%>\% 
  hc_add_series_scatter(mtcars$wt, mtcars$mpg, color = mtcars$cyl) \%>\% 
  hc_chart(zoomType = "xy") \%>\% 
  hc_title(text = "Motor Trend Car Road Tests") \%>\% 
  hc_subtitle(text = "Motor Trend Car Road Tests") \%>\% 
  hc_xAxis(title = list(text = "Weight")) \%>\% 
  hc_yAxis(title = list(text = "Miles/gallon")) \%>\% 
  hc_tooltip(headerFormat = "<b>{series.name} cylinders</b><br>",
             pointFormat = "{point.x} (lb/1000), {point.y} (miles/gallon)")

hc

thm <- hc_theme(
 colors = c('red', 'green', 'blue'),
 chart = list(
 backgroundColor = "#15C0DE"
 ),
 title = list(
   style = list(
     color = '#333333',
     fontFamily = "Erica One"
   )
 ),
 subtitle = list(
   style = list(
     color = '#666666',
     fontFamily = "Shadows Into Light"
   )
 ),
 legend = list(
   itemStyle = list(
     fontFamily = 'Tangerine',
     color = 'black'
   ),
   itemHoverStyle = list(
     color = 'gray'
   )   
  )
)

hc \%>\% hc_add_theme(thm)

}

