% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc.R
\name{hc_add_series}
\alias{hc_add_serie}
\alias{hc_add_series}
\title{Adding and removing series from highchart objects}
\usage{
hc_add_series(hc, ...)

hc_add_serie(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments defined in \url{http://api.highcharts.com/highcharts#chart}.}
}
\description{
Adding and removing series from highchart objects
}
\examples{

data("citytemp")

hc <- highchart() \%>\% 
  hc_xAxis(categories = citytemp$month) \%>\% 
  hc_add_series(name = "Tokyo", data = citytemp$tokyo) \%>\% 
  hc_add_series(name = "New York", data = citytemp$new_york) 

hc 

hc \%>\% 
  hc_add_series(name = "London", data = citytemp$london, type = "area") \%>\% 
  hc_rm_series(name = "New York")

}

