% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{tradesCleanupUsingQuotes}
\alias{tradesCleanupUsingQuotes}
\title{Perform a final cleaning procedure on trade data}
\usage{
tradesCleanupUsingQuotes(
  datasource = NULL,
  datadestination = NULL,
  tdata = NULL,
  qdata = NULL
)
}
\arguments{
\item{datasource}{character indicating the folder in which the original data is stored.}

\item{datadestination}{character indicating the folder in which the cleaned data is stored, folder of datasource by default.}

\item{tdata}{data.table or xts object containing (ONE day and for ONE stock only) trade data cleaned by \code{\link{tradesCleanup}}. This argument is NULL by default. Enabling it, means the arguments
from, to, datasource and datadestination will be ignored. (only advisable for small chunks of data)}

\item{qdata}{data.table or xts object containing (ONE day and for ONE stock only) cleaned quote data. This argument is NULL by default. Enabling it means the arguments
from, to, datasource, datadestination will be ignored. (only advisable for small chunks of data)}
}
\value{
For each day an xts object is saved into the folder of that date, containing the cleaned data.

In case you supply the arguments "tdata" and "qdata", the on-disk functionality is ignored
and the function returns cleaned trades as a data.table or xts object (see examples).
}
\description{
Function performs cleaning procedure \code{\link{rmTradeOutliersUsingQuotes}} 
for the trades of all stocks data in "datadestination". 
Note that preferably the input data for this function 
is trade and quote data cleaned by respectively e.g. \code{\link{tradesCleanup}}
and \code{\link{quotesCleanup}}.
}
\examples{
# Consider you have raw trade data for 1 stock for 2 days 
tdata_afterfirstcleaning <- tradesCleanup(tdataraw = sample_tdataraw_microseconds, 
                                          exchanges = "N", report = FALSE)
# 
qdata <- quotesCleanup(qdataraw = sample_qdataraw_microseconds, 
                       exchanges = "N", report = FALSE)
dim(tdata_afterfirstcleaning)
tdata_afterfinalcleaning <- 
  tradesCleanupUsingQuotes(qdata = qdata[as.Date(DT) == "2018-01-02"],
                           tdata = tdata_afterfirstcleaning[as.Date(DT) == "2018-01-02"])
dim(tdata_afterfinalcleaning)
#In case you have more data it is advised to use the on-disk functionality
#via "from","to","datasource", etc. arguments
}
\references{
Barndorff-Nielsen, O. E., P. R. Hansen, A. Lunde, and N. Shephard (2009). Realized kernels in practice: Trades and quotes. Econometrics Journal 12, C1-C32.

Brownlees, C.T. and Gallo, G.M. (2006). Financial econometric analysis at ultra-high frequency: Data handling concerns. Computational Statistics & Data Analysis, 51, pages 2232-2245.
}
\author{
Jonathan Cornelissen, Kris Boudt and Onno Kleen.
}
\keyword{cleaning}
