% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realizedMeasures.R
\name{rRVar}
\alias{rRVar}
\title{An estimator of realized variance.}
\usage{
rRVar(rData, alignBy = NULL, alignPeriod = NULL, makeReturns = FALSE, ...)
}
\arguments{
\item{rData}{an \code{xts} or \code{data.table} object containing returns or prices, possibly for multiple assets over multiple days.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. 
Possible values are: \code{"ticks"}, \code{"secs"}, \code{"seconds"}, \code{"mins"}, \code{"minutes"}, \code{"hours"}}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. For example, to aggregate
based on a 5-minute frequency, set \code{alignPeriod = 5} and \code{alignBy = "minutes"}.}

\item{makeReturns}{boolean, should be \code{TRUE} when \code{rData} contains prices instead of returns. \code{FALSE} by default.}

\item{...}{used internally, do not change.}
}
\value{
\itemize{
\item In case the input is an \code{xts} object with data from one day, a numeric of the same length as the number of assets.
\item If the input data spans multiple days and is in \code{xts} format, an \code{xts} will be returned.
\item If the input data is a \code{data.table} object, the function returns a \code{data.table} with the same column names as the input data, containing the date and the realized measures.
}
}
\description{
Calculates the daily Realized Variance.
Let \eqn{r_{t,i}} be an intraday return vector with \eqn{i=1,...,M} number of intraday returns.

Then, the realized variance is given by
\deqn{
 \mbox{RVar}_{t}=\sum_{i=1}^{M}r_{t,i}^{2}
}
}
\examples{
rv <- rRVar(sampleOneMinuteData, makeReturns = TRUE)
plot(rv[, DT], rv[, MARKET], xlab = "Date", ylab = "Realized Variance", type = "l")
}
\seealso{
\code{\link{IVar}} for a list of implemented estimators of the integrated variance.
}
\keyword{highfrequency}
\keyword{realized}
