
#' The package highriskzone provides tools to determine and evaluate high-risk zones of
#' unobserved events by using point process methodology.
#'
#' \tabular{ll}{
#' Package: \tab highriskzone\cr
#' Type: \tab Package\cr
#' Version: \tab 1.1\cr
#' Date: \tab 2013-10-31\cr
#' License: \tab MIT\cr
#' LazyLoad: \tab yes\cr
#' }
#'
#' @author
#' Heidi Seibold \email{Heidi.Seibold@@campus.lmu.de},
#' Monia Mahling \email{monia.mahling@@stat.uni-muenchen.de}
#' 
#'
#' Maintainer: Heidi Seibold \email{Heidi.Seibold@@campus.lmu.de}
#' @name highriskzone-package
#' @docType package
#' @aliases highriskzone package-highriskzone
#' @import spatstat ks
#' @title Determining high-risk zones by using spatial point process methodology
#' @keywords package
#' @references Monia Mahling, Michael \enc{Hhle}{Hoehle} & Helmut \enc{Kchenhoff}{Kuechenhoff} (2013),
#' \emph{Determining high-risk zones for unexploded World War II bombs by using point process methodology.}
#' Journal of the Royal Statistical Society, Series C 62(2), 181-199. \cr
#'
#' @references Monia Mahling (2013),
#' \emph{Determining high-risk zones by using spatial point process methodology.}
#' Ph.D. thesis, Cuvillier Verlag \enc{Gttingen}{Goettingen},
#' available online: http://edoc.ub.uni-muenchen.de/15886/\cr
#' 
#' Heidi Seibold (2012), \emph{Determining high risk zones using point process methodology 
#' - Realization by building an R package.} Bachelor Thesis, Ludwig Maximilian University of Munich.
#' @seealso  \code{\link[spatstat]{spatstat-package}}
#' @encoding latin1
#' 
NULL