% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generichrz.R
\name{plot.highriskzone}
\alias{plot.highriskzone}
\title{Plot a high-risk zone}
\usage{
\method{plot}{highriskzone}(
  x,
  ...,
  pattern = NULL,
  win = NULL,
  plotpattern = FALSE,
  plotwindow = FALSE,
  windowcol = "white",
  usegpclib = FALSE,
  zonecol = "grey"
)
}
\arguments{
\item{x}{high-risk zone (object of class "\code{highriskzone}")}

\item{...}{extra arguments passed to the generic \code{\link[graphics]{plot}} function}

\item{pattern}{spatial point pattern for which the highriskzone was determined.}

\item{win}{observation winodw}

\item{plotpattern}{logical flag; if \code{TRUE}, the point pattern is plotted.}

\item{plotwindow}{logical flag; if \code{TRUE}, the observation window is plotted.}

\item{windowcol}{the color used to plot the observation window}

\item{usegpclib}{logical flag; if \code{TRUE}, the observation window is transformed in a 
polygonal window (object of class "\code{owin}" and of type "\code{polygonal}").
See \code{\link[spatstat.geom]{as.polygonal}}}

\item{zonecol}{the colour used to plot the high-risk zone.}
}
\description{
Plot a high-risk zone.
}
\details{
This is the plot method for the class \code{highriskzone}.
}
\seealso{
\code{\link[graphics]{plot}}, for examples see \code{\link{det_hrz}}
}
