% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VqN.R
\name{VqN}
\alias{VqN}
\title{Sørensen-type turnover-complement}
\usage{
VqN(beta, N)
}
\arguments{
\item{beta}{A beta diversity value based on Hill numbers.}

\item{N}{An integer indicating sample size, the number of sampling units to be used to compute the similarity measure.}
}
\value{
A Sørensen-type turnover-complement value
}
\description{
The Sørensen-type turnover-complement is the complement of the Sørensen-type turnover, which quantifies the normalized OTU turnover rate with respect to the average subsystem (i.e., alpha), thus provides the proportion of a typical subsystem that changes across subsystems. VqN is integrated in the functions beta_dis() and pair_dis().
}
\details{
Sørensen-type turnover-complement
}
\examples{
VqN(beta=1.24,N=2)
VqN(1.24,2)
}
\references{
Alberdi, A., Gilbert, M.T.P. (2019). A guide to the application of Hill numbers to DNA-based diversity analyses. Molecular Ecology Resources, 19, 804-817.\cr\cr
Chao, A., Chiu, C.H., & Hsieh, T. C. (2012). Proposing a resolution to debates on diversity partitioning. Ecology, 93, 2037-2051.\cr\cr
Jost, L. (2007). Partitioning diversity into independent alpha and beta components. Ecology, 88, 2427-2439.
}
\seealso{
\code{\link{div_part}}, \code{\link{beta_dis}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{beta}
\keyword{dissimilarity}
\keyword{similarity}
