% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_test_plot.R
\name{div_test_plot}
\alias{div_test_plot}
\title{Diversity test plotting}
\usage{
div_test_plot(divtest, chart, colour, posthoc, threshold)
}
\arguments{
\item{divtest}{Object outputed by the div_test() function}

\item{chart}{Chart type, either 'box' for boxplot, 'jitter' for jitter plot or 'violin' for violin plot. chart="box"}

\item{colour}{The number of vector items (colours, e.g. '#34k235'), must equal the number of groups that are intended to plot.}

\item{posthoc}{If 'TRUE' pairwise p-values of the posthoc analyses will be ploted. It requires the div_test() object to contain posthoc results.}

\item{threshold}{Maximum p-value to show in pairwise posthoc results (usually 0.05, but could be any other number between 0 an 1). P-values above the threshold will not be showed.}
}
\value{
Chart of (mean) diversities of contrasting groups with optional posthoc results.
}
\description{
Plot of diversity comparison between groups of samples
}
\details{
Diversity test plotting
}
\examples{
data(bat.diet.otutable)
data(bat.diet.hierarchy)
divtestres <- div_test(bat.diet.otutable,qvalue=0,hierarchy=bat.diet.hierarchy)
div_test_plot(divtestres,chart="box")
div_test_plot(divtestres,chart="violin")
divtest.res.ph <- div_test(bat.diet.otutable,qvalue=0,hierarchy=bat.diet.hierarchy,posthoc=TRUE)
div_test_plot(divtest.res.ph,chart="jitter",posthoc=TRUE,threshold=0.5)
}
\seealso{
\code{\link{div_test}}, \code{\link{hill_div}}, \code{\link{div_part}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{chart}
\keyword{comparison}
\keyword{hill}
\keyword{numbers}
