% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return.level.R
\name{return.level}
\alias{return.level}
\title{The associated return level}
\usage{
return.level(period, mu, sigma, xi)
}
\arguments{
\item{period}{An integer greater than 1.
Gives the period \eqn{T} over which the return level is computed. See details.}

\item{mu}{A numerical value or a vector of real values.
GEV location parameter. Must be of length one or same length as \code{sigma} and/or \code{xi}.}

\item{sigma}{A numerical value or a vector of real values.
GEV scale parameter. Must be of length one or same length as \code{mu} and/or \code{xi}.}

\item{xi}{A numerical value or a vector of real values.
GEV shape parameter. Must be of length one or same length as \code{mu} and/or \code{sigma}.}
}
\value{
This function returns either a numerical value or a numerical vector. If \code{mu}, \code{sigma}, \code{xi} are of length one each, it returns a single numerical value. Otherwise, it returns a vector with length corresponding to the given GEV parameters.
}
\description{
Computation of the associated return level with given period and GEV parameters.
}
\details{
The \eqn{T}-year return level is a typical value of interest in Extreme Value Theory. It represents the value that is expected to be exceeded once over \eqn{T} years. Given the parameters \eqn{\mu}, \eqn{\sigma} and \eqn{\xi} of the GEV distribution associated to the yearly maxima, we can compute the associated \eqn{T}-return level \eqn{y_T} by:
\deqn{y_T := \mu + \frac{\sigma}{\xi} \left[ \log\left(\frac{T}{T-1}\right)^{-\xi} -1 \right] ~.}
}
\examples{
return.level(period = 100, mu = 1, sigma = 1, xi = 1)
return.level(period = 200, mu = 1:10, sigma = 1, xi = 0)


}
\author{
Quentin Sebille
}

