% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fullwave.R
\name{full_wave}
\alias{full_wave}
\title{Automatic Wave Calculation}
\usage{
full_wave(
  data,
  ranges,
  targets,
  old_emulators = NULL,
  prop_train = 0.7,
  cutoff = 3,
  nth = 1,
  verbose = interactive(),
  n_points = nrow(data),
  ...
)
}
\arguments{
\item{data}{The data to train with.}

\item{ranges}{The ranges of the input parameters}

\item{targets}{The output targets to match to.}

\item{old_emulators}{Any emulators from previous waves.}

\item{prop_train}{What proportion of the data is used for training.}

\item{cutoff}{The implausibility cutoff for point generation and diagnostics.}

\item{nth}{The level of maximum implausibility to consider.}

\item{verbose}{Should progress be printed to console?}

\item{n_points}{The number of points to generate from \code{\link{generate_new_design}}.}

\item{...}{Any arguments to be passed to \code{\link{emulator_from_data}}.}
}
\value{
A list of two objects: \code{points} and \code{emulators}
}
\description{
Performs a full wave of emulation and history matching, given data.
}
\details{
This function uses all of the functionality from the package in a relatively conservative form.
The function performs the following steps:

1) Split the data into a training set and a validation set, where \code{prop_train} indicates
what proportion of the data is used to train.

2) Perform emulator training using \code{\link{emulator_from_data}}. If a more involved
specification is desired, optional arguments can be passed to \code{emulator_from_data} using
the \code{...} argument.

3) Perform diagnostics on the trained emulators, removing emulators that do not display
acceptable performance. Global emulator variance may also be modified to ensure that none of
the emulators demonstrate misclassification errors (from \code{\link{classification_diag}}).

4) Ordering the remaining emulators from most restrictive to least restrictive on the dataset
provided at this wave. Some point generation mechanisms terminate early if a point is ruled
out by a single emulator, so the ordering ensures this happens earlier rather than later.

5) Generate the new points using the default method of \code{\link{generate_new_design}}, using
the normal procedure (for details, see the description for generate_new_design). By default, it
generates the same number of points as it was provided to train and validate on.

If the parameter \code{old_emulators} is provided, this should be a list of emulators used
at all previous waves - for example if \code{full_wave} is used to do a second wave of
history matching, then \code{old_emulators} would contain the list of first-wave emulators.

The function returns a list of two objects: \code{emulators} corresponding to this wave's
emulators, and \code{points} corresponding to the new proposed points. The points can then
be put into the simulator to generate runs for a subsequent wave.
}
\examples{
\donttest{ #excessive runtime
 ranges <- list(aSI = c(0.1, 0.8), aIR = c(0, 0.5), aSR = c(0, 0.05))
 default <- full_wave(do.call('rbind.data.frame', SIRSample), ranges,
  SIREmulators$targets)
 non_quad <- full_wave(do.call('rbind.data.frame', SIRSample), ranges,
  SIREmulators$targets, quadratic = FALSE)
 second <- full_wave(SIRMultiWaveData[[2]], ranges, SIREmulators$targets,
  old_emulators = SIRMultiWaveEmulators[[1]])
 }
}
