% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icecurves.R
\name{plot_icecurves}
\alias{plot_icecurves}
\title{Download and plot essential climate data}
\usage{
plot_icecurves(dataset = get_icecurves(), region = "Arctic", print = TRUE)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{get_icecurves}, defaults to calling \code{get_icecurves}}

\item{region}{Used in chart title, defaults to "Arctic"}

\item{print}{(boolean) Display sea ice ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}
}
\value{
Invisibly returns a ggplot2 object with Sea Ice Index chart
}
\description{
Plots the monthly Sea Ice Index data retrieved using \code{get_icecurves()} with ggplot2. The output ggplot2 object may be further modified.
}
\details{
\code{plot_icecurves} invisibly returns a ggplot2 object with a pre-defined Sea Ice Index chart using data from \code{get_icecurves}.
By default the chart is also displayed. Users may further modify the output ggplot2 chart.
Chart consists of one line per year showing monthly sea ice from January through December. Current year is highlighted.
}
\examples{
\donttest{
# Fetch historic monthly sea ice data since 1979:
icecurves <- get_icecurves()
#
# Plot output using package's built-in ggplot2 defaults
plot_icecurves(icecurves)

# Or just call plot_icecurves(), which defaults to get_icecurves() dataset
plot_icecurves()

p <- plot_icecurves(icecurves, print = FALSE)
p + ggplot2::labs(title='Shrinking Arctic Sea Ice') }

}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
