% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methane.R
\name{plot_methane}
\alias{plot_methane}
\title{Download and plot essential climate data}
\usage{
plot_methane(dataset = get_methane(), print = TRUE, annot = TRUE)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{get_methane}}

\item{print}{(boolean) Display methane ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}

\item{annot}{(boolean) Include chart annotation with latest date and value, defaults to TRUE.}
}
\value{
Invisibly returns a ggplot2 object with methane chart
}
\description{
Plots atmospheric methane data retrieved using \code{get_methane()} with ggplot2. The output ggplot2 object may be modified.
}
\details{
\code{plot_methane} invisibly returns a ggplot2 object with a pre-defined methane chart using data from \code{get_methane}.
By default the chart is also displayed. Users may further modify the output ggplot2 chart.
}
\examples{
\donttest{
# Fetch methane data:
ch4 <- get_methane()
#
# Plot output using package's built-in ggplot2 defaults
plot_methane(ch4)

# Or just call plot_methane(), which defaults to get_methane() dataset
plot_methane()

p <- plot_methane(ch4, print = FALSE)
# Modify plot such as: p + ggplot2::labs(title='Trend in Atmospheric Methane') }

}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
