% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_brown_c_holland.R
\name{con_brown_c_holland}
\alias{con_brown_c_holland}
\title{Congruence Index c according to Brown & Gore (1994)}
\usage{
con_brown_c_holland(a, b)
}
\arguments{
\item{a}{a character vector with person Holland codes.}

\item{b}{a character vector with environment Holland codes.}
}
\value{
a numeric with value for congruence.
}
\description{
This function computes an index od congruence according to Brown & Gore (1994).
}
\details{
The function finds the congruence according to Brown & Gore (1994) between the three-letter Holland-codes given in argument a, which is the person code, and argument b, which is the environment code. The Index is (currently) only defined for three letters from the Holland code. The degree of congruence is output, according to its definition by Brown & Gore (1994), as a reciprocal value of a distance. This means, for example, that a value of '18' is the result for a perfect fit !
}
\examples{
con_brown_c_holland(a="RIA",b="SEC") # max. difference 
con_brown_c_holland(a="RIA",b="RIA") # max. similarity
}
\references{
Brown & Gore (1994). An Evaluation of interest congruence indices: Distribution Characteristics and Measurement Properties. \emph{Journal of Vocational Behaviour, 45}, 310-327.
}
\keyword{congruence}
