% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hover_download_button.R
\name{hover_download_button}
\alias{hover_download_button}
\title{Download button with button and icon animations}
\source{
\url{https://github.com/IanLunn/Hover}
}
\usage{
hover_download_button(
  outputId,
  label = "Download",
  button_animation = NULL,
  icon_animation = NULL,
  class = NULL,
  ...
)
}
\arguments{
\item{outputId}{The name of the output slot that the downloadHandler is assigned to.}

\item{label}{The label that should appear on the button.}

\item{button_animation}{The name of the button animation.}

\item{icon_animation}{The name of the icon animation.}

\item{class}{Additional CSS classes to apply to the tag, if any.}

\item{...}{Other arguments to pass to the container tag function.}
}
\description{
Animate a downloadButton and it's icon using
\href{https://github.com/IanLunn/Hover}{Hover.css}
}
\examples{
if (interactive()) {
  library(shiny)
  library(hover)

  ui <- fluidPage(
    use_hover(),
    hover_download_button(
      outputId = "downloadData",
      label = "Download",
      button_animation = "rotate",
      icon_animation = "spin"
    )
  )

  server <- function(input, output) {
    # Our dataset
    data <- mtcars

    output$downloadData <- downloadHandler(
      filename = function() {
        paste("data-", Sys.Date(), ".csv", sep="")
      },
      content = function(file) {
        write.csv(data, file)
      }
    )
  }

  shinyApp(ui, server)
}
}
