% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server-side.R
\name{howlerServer}
\alias{howlerServer}
\alias{changeTrack}
\alias{addTrack}
\alias{playHowl}
\alias{pauseHowl}
\alias{togglePlayHowl}
\alias{stopHowl}
\alias{seekHowl}
\title{Update howler.js Server-Side}
\usage{
changeTrack(id, track, session = getDefaultReactiveDomain())

addTrack(id, track, play_track = FALSE, session = getDefaultReactiveDomain())

playHowl(id, session = getDefaultReactiveDomain())

pauseHowl(id, session = getDefaultReactiveDomain())

togglePlayHowl(id, session = getDefaultReactiveDomain())

stopHowl(id, session = getDefaultReactiveDomain())

seekHowl(id, seek, session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{ID of the \code{howler} to update}

\item{track}{Either the track name of the file to change to, or the index of the file to play.
If the file is not included in the player nothing will happen.}

\item{session}{Shiny session}

\item{play_track}{Logical, should the new track be played on addition?}

\item{seek}{Time (in seconds) to set the position of the track}
}
\value{
Updates the the state of the specified \code{howler} in the shiny application.
}
\description{
Change the state of the howler player from the server.

\code{playHowl}, \code{pauseHowl}, \code{togglePlayHowl} and \code{stopHowl}
will all be applied to the current track.

\code{changeTrack} will update the track to the file specified.

\code{addTrack} will add a new track to the specified player.
}
\examples{
if (interactive()) {
  library(shiny)

  tracks <- c("audio/track1.mp3", "audio/track2.mp3")

  ui <- fluidPage(
    title = "howler.js Player",
    selectInput("track", "Select Track", basename(tracks)),
    howler(elementId = "howler", tracks),
    howlerPlayPauseButton("howler")
  )

  server <- function(input, output) {
    observeEvent(input$track, changeHowlerTrack("howler", input$track))
  }

  runShiny(ui, server)
}

}
