% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plot.seriesrevision}
\alias{plot.seriesrevision}
\title{Plot method for `seriesrevision` object}
\usage{
\method{plot}{seriesrevision}(x, measure = "median", ...)
}
\arguments{
\item{x}{Object to plot of class `seriesrevision`}

\item{measure}{default = 'median'; Metric to plot ('median' or 'mean')}

\item{...}{Additional Arguments}
}
\value{
`plotrevision` object inheriting from a ggplot object
}
\description{
Specific plotting method for seriesrevision objects
}
\examples{

 # Load example sales
 data(ex_sales)

 # Create Index
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 # Create Series (Suppressing messages do to small sample size of this example)
 suppressMessages(
   hpi_series <- createSeries(hpi_obj = rt_index,
                              train_period = 12))

 # Calculate revision
 series_rev <-  calcRevision(series_obj = hpi_series)

 # Make Plot
 plot(series_rev)

}
