% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpiModel.R
\name{hpiModel.rf}
\alias{hpiModel.rf}
\title{Specific method for hpi modeling (hed) approach)}
\usage{
\method{hpiModel}{rf}(model_type, hpi_df, estimator = "pdp",
  log_dep = TRUE, trim_model = TRUE, mod_spec = NULL,
  dep_var = NULL, ind_var = NULL, ...)
}
\arguments{
\item{model_type}{Type of model ('rt', 'hed', 'rf')}

\item{hpi_df}{Dataset created by one of the *CreateSales() function in this package.}

\item{estimator}{Type of estimator to be used ('base', 'weighted', 'robust')}

\item{log_dep}{default=TRUE; should the dependent variable (change in price) be logged?}

\item{trim_model}{default TRUE, should excess be trimmed from model results ('lm' or 'rlm' object)?}

\item{mod_spec}{default=NULL; hedonic model specification}

\item{dep_var}{default=NULL; dependent variable of the model}

\item{ind_var}{default=NULL; independent variable(s) of the model}

\item{...}{Additional Arguments}
}
\value{
hpimodel object consisting of:
\describe{
\item{estimator}{Type of estimator}
\item{coefficients}{Data.frame of coefficient}
\item{model_obj}{class `rtmodel` or `hedmodel`}
\item{mod_spec}{Full model specification}
\item{log_dep}{Binary: is the dependent variable in logged format}
\item{base_price}{Mean price in the base period}
\item{periods}{`data.frame` of periods}
\item{approach}{Type of model used}
}
}
\description{
Estimate hpi models with hed approach
}
