% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtModel.R
\name{rtModel}
\alias{rtModel}
\title{Estimate repeat transaction model for index creation}
\usage{
rtModel(rt_df, time_matrix, price_diff, estimator, lm_recover = TRUE,
  ...)
}
\arguments{
\item{rt_df}{Repeat transactions dataset from rtCreateTrans()}

\item{time_matrix}{Time matrix object from rtTimeMatrix()}

\item{price_diff}{Difference in price between the two transactions}

\item{estimator}{Type of model to estimates (base, robust, weighted).  Must be in that class.}

\item{lm_recover}{(TRUE) Allows robust model to use linear model if it fails}

\item{...}{Additional arguments}
}
\value{
`rtmodel` object
}
\description{
Estimate coefficients for an index via the repeat transaction approach (generic method)
}
\section{Further Details}{

Three available specific methods: 'base', 'robust' and 'weighted'
}

\examples{

  # Load data
  data(ex_sales)

  # With a raw transaction data.frame
  rt_data <- rtCreateTrans(trans_df = ex_sales,
                           prop_id = 'pinx',
                           trans_id = 'sale_id',
                           price = 'sale_price',
                           periodicity = 'monthly',
                           date = 'sale_date')

  # Calc price differences
  price_diff <- rt_data$price_2 - rt_data$price_1

  # Create time matrix
  rt_matrix <- rtTimeMatrix(rt_data)

  # Calculate model
  rt_model <- rtModel(rt_df = rt_data,
                      price_diff = price_diff,
                      time_matrix = rt_matrix,
                      estimator = structure('base', class='base'))

}
