% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrq_glasso_predict.R
\name{predict.hrq_glasso}
\alias{predict.hrq_glasso}
\title{Prediction for the hrq_glasso object}
\usage{
\method{predict}{hrq_glasso}(object, newX, s = NULL, ...)
}
\arguments{
\item{object}{The model object of \code{hrq_glasso}.}

\item{newX}{New design matrix.}

\item{s}{Value of lambda. Default is NULL, so that the function provides prediction at all lambdas used in \code{hrq_glasso}.}

\item{...}{other input parameters.}
}
\value{
The function returns predicted values based on the fitted model from \code{hrq_glasso}.
}
\description{
This function provides the prediction of the \code{hrq_glasso} object.
}
\examples{
n<- 100
p<- 10
x0<- matrix(rnorm(n*p),n,p)
X<- cbind(x0, x0^2, x0^3)[,order(rep(1:p,3))]
y<- -2+X[,1]+0.5*X[,2]-X[,3]-0.5*X[,7]+X[,8]-0.2*X[,9]+rt(n,2)
group<- rep(1:p, each=3)
fit<- hrq_glasso(X, y, group)
pred<- predict(fit, newX=X, s=0.3)
}
