% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_manova_II.R
\name{mc_manova_II}
\alias{mc_manova_II}
\title{MANOVA type II table for mcglm objects via Wald test.}
\usage{
mc_manova_II(object, verbose = TRUE)
}
\arguments{
\item{object}{An object of \code{mcglm} class.}

\item{verbose}{a logical if TRUE print some information about the
tests performed. Default verbose = TRUE.}
}
\value{
Type II MANOVA table for mcglm objects.
}
\description{
Performs Wald tests to generate multivariate type-II
analysis-of-variance tables for model objects produced by mcglm.
}
\examples{

library(mcglm)
library(Matrix)
library(htmcglm)

data("soya", package = "mcglm")

form.grain <- grain ~ water * pot
form.seed <- seeds ~ water * pot

soya$viablepeasP <- soya$viablepeas / soya$totalpeas
form.peas <- viablepeasP ~ water * pot

Z0 <- mc_id(soya)
Z1 <- mc_mixed(~0 + factor(block), data = soya)

fit_joint <- mcglm(linear_pred = c(form.grain,
                                   form.seed,
                                   form.peas),
                   matrix_pred = list(c(Z0, Z1),
                                      c(Z0, Z1),
                                      c(Z0, Z1)),
                   link = c("identity",
                            "log",
                            "logit"),
                   variance = c("constant",
                                "tweedie",
                                "binomialP"),
                   Ntrial = list(NULL,
                                 NULL,
                                 soya$totalpeas),
                   power_fixed = c(TRUE,TRUE,TRUE),
                   data = soya)

mc_manova_II(fit_joint)

}
\seealso{
\code{mc_manova_I}, \code{mc_manova_III} and
\code{mc_manova_disp}.
}
\author{
Lineu Alberto Cavazani de Freitas,
\email{lineuacf@gmail.com}
}
